#
# Basic DB data for phpBB2 devel
#
# $Id: mysql_basic.sql,v 1.29.2.6 2003/07/20 13:14:27 acydburn Exp $

# -- Config
INSERT INTO phpbb_config (config_name, config_value) VALUES ('config_id','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_disable','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sitename','yourdomain.com');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('site_desc','A _little_ text to describe your forum');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cookie_name','phpbb2mysql');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cookie_path','/');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cookie_domain','');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cookie_secure','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('session_length','3600');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_html','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_html_tags','b,i,u,pre');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_bbcode','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_smilies','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_sig','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_namechange','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_theme_create','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_avatar_local','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_avatar_remote','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_avatar_upload','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('enable_confirm', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('override_user_style','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('posts_per_page','15');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('topics_per_page','50');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('hot_threshold','25');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_poll_options','10');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_sig_chars','255');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_inbox_privmsgs','50');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_sentbox_privmsgs','25');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_savebox_privmsgs','50');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_email_sig','Thanks, The Management');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_email','youraddress@yourdomain.com');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smtp_delivery','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smtp_host','');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smtp_username','');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smtp_password','');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sendmail_fix','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('require_activation','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('flood_interval','15');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_email_form','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('avatar_filesize','6144');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('avatar_max_width','80');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('avatar_max_height','80');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('avatar_path','images/avatars');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('avatar_gallery_path','images/avatars/gallery');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smilies_path','images/smiles');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('default_style','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('default_dateformat','D M d, Y g:i a');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_timezone','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('prune_enable','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('privmsg_disable','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('gzip_compress','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('coppa_fax', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('coppa_mail', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('record_online_users', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('record_online_date', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('server_name', 'www.myserver.tld');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('server_port', '80');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('script_path', '/phpBB2/');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('version', '.0.6');


# -- Categories
INSERT INTO phpbb_categories (cat_id, cat_title, cat_order) VALUES (1, 'Test category 1', 10);


# -- Forums
INSERT INTO phpbb_forums (forum_id, forum_name, forum_desc, cat_id, forum_order, forum_posts, forum_topics, forum_last_post_id, auth_view, auth_read, auth_post, auth_reply, auth_edit, auth_delete, auth_announce, auth_sticky, auth_pollcreate, auth_vote, auth_attachments) VALUES (1, 'Test Forum 1', 'This is just a test forum.', 1, 10, 1, 1, 1, 0, 0, 0, 0, 1, 1, 3, 3, 1, 1, 3);


# -- Users
INSERT INTO phpbb_users (user_id, username, user_level, user_regdate, user_password, user_email, user_icq, user_website, user_occ, user_from, user_interests, user_sig, user_viewemail, user_style, user_aim, user_yim, user_msnm, user_posts, user_attachsig, user_allowsmile, user_allowhtml, user_allowbbcode, user_allow_pm, user_notify_pm, user_allow_viewonline, user_rank, user_avatar, user_lang, user_timezone, user_dateformat, user_actkey, user_newpasswd, user_notify, user_active) VALUES ( -1, 'Anonymous', 0, 0, '', '', '', '', '', '', '', '', 0, NULL, '', '', '', 0, 0, 1, 0, 1, 0, 1, 1, NULL, '', '', 0, '', '', '', 0, 0);

# -- username: admin    password: admin (change this or remove it once everything is working!)
INSERT INTO phpbb_users (user_id, username, user_level, user_regdate, user_password, user_email, user_icq, user_website, user_occ, user_from, user_interests, user_sig, user_viewemail, user_style, user_aim, user_yim, user_msnm, user_posts, user_attachsig, user_allowsmile, user_allowhtml, user_allowbbcode, user_allow_pm, user_notify_pm, user_popup_pm, user_allow_viewonline, user_rank, user_avatar, user_lang, user_timezone, user_dateformat, user_actkey, user_newpasswd, user_notify, user_active) VALUES ( 2, 'Admin', 1, 0, '21232f297a57a5a743894a0e4a801fc3', 'admin@yourdomain.com', '', '', '', '', '', '', 1, 1, '', '', '', 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, '', 'english', 0, 'd M Y h:i a', '', '', 0, 1);


# -- Ranks
INSERT INTO phpbb_ranks (rank_id, rank_title, rank_min, rank_special, rank_image) VALUES ( 1, 'Site Admin', -1, 1, NULL);


# -- Groups
INSERT INTO phpbb_groups (group_id, group_name, group_description, group_single_user) VALUES (1, 'Anonymous', 'Personal User', 1);
INSERT INTO phpbb_groups (group_id, group_name, group_description, group_single_user) VALUES (2, 'Admin', 'Personal User', 1);


# -- User -> Group
INSERT INTO phpbb_user_group (group_id, user_id, user_pending) VALUES (1, -1, 0);
INSERT INTO phpbb_user_group (group_id, user_id, user_pending) VALUES (2, 2, 0);


# -- Demo Topic
INSERT INTO phpbb_topics (topic_id, topic_title, topic_poster, topic_time, topic_views, topic_replies, forum_id, topic_status, topic_type, topic_vote, topic_first_post_id, topic_last_post_id) VALUES (1, 'Welcome to phpBB 2', 2, '972086460', 0, 0, 1, 0, 0, 0, 1, 1);


# -- Demo Post
INSERT INTO phpbb_posts (post_id, topic_id, forum_id, poster_id, post_time, post_username, poster_ip) VALUES (1, 1, 1, 2, 972086460, NULL, '7F000001');
INSERT INTO phpbb_posts_text (post_id, post_subject, post_text) VALUES (1, NULL, 'This is an example post in your phpBB 2 installation. You may delete this post, this topic and even this forum if you like since everything seems to be working!');


# -- Themes
INSERT INTO phpbb_themes (themes_id, template_name, style_name, head_stylesheet, body_background, body_bgcolor, body_text, body_link, body_vlink, body_alink, body_hlink, tr_color1, tr_color2, tr_color3, tr_class1, tr_class2, tr_class3, th_color1, th_color2, th_color3, th_class1, th_class2, th_class3, td_color1, td_color2, td_color3, td_class1, td_class2, td_class3, fontface1, fontface2, fontface3, fontsize1, fontsize2, fontsize3, fontcolor1, fontcolor2, fontcolor3, span_class1, span_class2, span_class3) VALUES (1, 'subSilver', 'subSilver', 'subSilver.css', '', 'E5E5E5', '000000', '006699', '5493B4', '', 'DD6900', 'EFEFEF', 'DEE3E7', 'D1D7DC', '', '', '', '98AAB1', '006699', 'FFFFFF', 'cellpic1.gif', 'cellpic3.gif', 'cellpic2.jpg', 'FAFAFA', 'FFFFFF', '', 'row1', 'row2', '', 'Verdana, Arial, Helvetica, sans-serif', 'Trebuchet MS', 'Courier, \'Courier New\', sans-serif', 10, 11, 12, '444444', '006600', 'FFA34F', '', '', '');

INSERT INTO phpbb_themes_name (themes_id, tr_color1_name, tr_color2_name, tr_color3_name, tr_class1_name, tr_class2_name, tr_class3_name, th_color1_name, th_color2_name, th_color3_name, th_class1_name, th_class2_name, th_class3_name, td_color1_name, td_color2_name, td_color3_name, td_class1_name, td_class2_name, td_class3_name, fontface1_name, fontface2_name, fontface3_name, fontsize1_name, fontsize2_name, fontsize3_name, fontcolor1_name, fontcolor2_name, fontcolor3_name, span_class1_name, span_class2_name, span_class3_name) VALUES (1, 'The lightest row colour', 'The medium row color', 'The darkest row colour', '', '', '', 'Border round the whole page', 'Outer table border', 'Inner table border', 'Silver gradient picture', 'Blue gradient picture', 'Fade-out gradient on index', 'Background for quote boxes', 'All white areas', '', 'Background for topic posts', '2nd background for topic posts', '', 'Main fonts', 'Additional topic title font', 'Form fonts', 'Smallest font size', 'Medium font size', 'Normal font size (post body etc)', 'Quote & copyright text', 'Code text colour', 'Main table header text colour', '', '', '');


# -- Smilies
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 1, ':D', 'icon_biggrin.gif', 'Very Happy');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 2, ':-D', 'icon_biggrin.gif', 'Very Happy');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 3, ':grin:', 'icon_biggrin.gif', 'Very Happy');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 4, ':)', 'icon_smile.gif', 'Smile');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 5, ':-)', 'icon_smile.gif', 'Smile');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 6, ':smile:', 'icon_smile.gif', 'Smile');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 7, ':(', 'icon_sad.gif', 'Sad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 8, ':-(', 'icon_sad.gif', 'Sad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 9, ':sad:', 'icon_sad.gif', 'Sad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 10, ':o', 'icon_surprised.gif', 'Surprised');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 11, ':-o', 'icon_surprised.gif', 'Surprised');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 12, ':eek:', 'icon_surprised.gif', 'Surprised');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 13, ':shock:', 'icon_eek.gif', 'Shocked');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 14, ':?', 'icon_confused.gif', 'Confused');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 15, ':-?', 'icon_confused.gif', 'Confused');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 16, ':???:', 'icon_confused.gif', 'Confused');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 17, '8)', 'icon_cool.gif', 'Cool');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 18, '8-)', 'icon_cool.gif', 'Cool');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 19, ':cool:', 'icon_cool.gif', 'Cool');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 20, ':lol:', 'icon_lol.gif', 'Laughing');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 21, ':x', 'icon_mad.gif', 'Mad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 22, ':-x', 'icon_mad.gif', 'Mad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 23, ':mad:', 'icon_mad.gif', 'Mad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 24, ':P', 'icon_razz.gif', 'Razz');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 25, ':-P', 'icon_razz.gif', 'Razz');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 26, ':razz:', 'icon_razz.gif', 'Razz');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 27, ':oops:', 'icon_redface.gif', 'Embarassed');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 28, ':cry:', 'icon_cry.gif', 'Crying or Very sad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 29, ':evil:', 'icon_evil.gif', 'Evil or Very Mad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 30, ':twisted:', 'icon_twisted.gif', 'Twisted Evil');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 31, ':roll:', 'icon_rolleyes.gif', 'Rolling Eyes');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 32, ':wink:', 'icon_wink.gif', 'Wink');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 33, ';)', 'icon_wink.gif', 'Wink');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 34, ';-)', 'icon_wink.gif', 'Wink');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 35, ':!:', 'icon_exclaim.gif', 'Exclamation');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 36, ':?:', 'icon_question.gif', 'Question');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 37, ':idea:', 'icon_idea.gif', 'Idea');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 38, ':arrow:', 'icon_arrow.gif', 'Arrow');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 39, ':|', 'icon_neutral.gif', 'Neutral');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 40, ':-|', 'icon_neutral.gif', 'Neutral');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 41, ':neutral:', 'icon_neutral.gif', 'Neutral');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 42, ':mrgreen:', 'icon_mrgreen.gif', 'Mr. Green');


# -- wordlist
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 1, 'example', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 2, 'post', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 3, 'phpbb', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 4, 'installation', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 5, 'delete', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 6, 'topic', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 7, 'forum', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 8, 'since', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 9, 'everything', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 10, 'seems', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 11, 'working', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 12, 'welcome', 0 );


# -- wordmatch
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 1, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 2, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 3, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 4, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 5, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 6, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 7, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 8, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 9, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 10, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 11, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 12, 1, 1 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 3, 1, 1 );

# -- Categories hierarchy
ALTER TABLE phpbb_categories ADD cat_main_type CHAR(1);
ALTER TABLE phpbb_categories ADD cat_main MEDIUMINT(8) UNSIGNED DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_categories ADD cat_desc TEXT NOT NULL;
ALTER TABLE phpbb_categories ADD icon VARCHAR(255);
ALTER TABLE phpbb_forums ADD forum_link VARCHAR(255);
ALTER TABLE phpbb_forums ADD forum_link_internal TINYINT(1) NOT NULL;
ALTER TABLE phpbb_forums ADD forum_link_hit_count TINYINT(1) NOT NULL;
ALTER TABLE phpbb_forums ADD forum_link_hit BIGINT(20) UNSIGNED NOT NULL;
ALTER TABLE phpbb_forums ADD icon VARCHAR(255);
ALTER TABLE phpbb_forums ADD main_type CHAR(1);
ALTER TABLE phpbb_users ADD user_sub_forum TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_split_cat TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_last_topic_title TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_sub_level_links TINYINT(1) DEFAULT '2' NOT NULL;
ALTER TABLE phpbb_users ADD user_display_viewonline TINYINT(1) DEFAULT '2' NOT NULL;

# -- attachments_config
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('upload_dir','files');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('upload_img','images/icon_clip.gif');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('topic_icon','images/icon_clip.gif');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('display_order','0');

INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('max_filesize','262144');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('attachment_quota','52428800');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('max_filesize_pm','262144');

INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('max_attachments','3');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('max_attachments_pm','1');

INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('disable_mod','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('allow_pm_attach','1');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('attachment_topic_review','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('allow_ftp_upload','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('show_apcp','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('attach_version','2.3.9');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('default_upload_quota', '0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('default_pm_quota', '0');

INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('ftp_server','');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('ftp_path','');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('download_path','');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('ftp_user','');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('ftp_pass','');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('ftp_pasv_mode','1');

INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_display_inlined','1');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_max_width','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_max_height','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_link_width','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_link_height','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_create_thumbnail','0');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_min_thumb_filesize','12000');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('img_imagick', '');
INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('use_gd2','0');

INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('wma_autoplay','0');

INSERT INTO phpbb_attachments_config (config_name, config_value) VALUES ('flash_autoplay','0');

# -- forbidden_extensions
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (1,'php');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (2,'php3');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (3,'php4');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (4,'phtml');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (5,'pl');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (6,'asp');
INSERT INTO phpbb_forbidden_extensions (ext_id, extension) VALUES (7,'cgi');

# -- extension_groups
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (1,'Images',1,1,1,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (2,'Archives',0,1,1,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (3,'Plain Text',0,0,1,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (4,'Documents',0,0,1,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (5,'Real Media',0,0,2,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (6,'Streams',2,0,1,'',0,'');
INSERT INTO phpbb_extension_groups (group_id, group_name, cat_id, allow_group, download_mode, upload_icon, max_filesize, forum_permissions) VALUES (7,'Flash Files',3,0,1,'',0,'');

# -- extensions
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (1, 1,'gif', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (2, 1,'png', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (3, 1,'jpeg', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (4, 1,'jpg', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (5, 1,'tif', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (6, 1,'tga', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (7, 2,'gtar', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (8, 2,'gz', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (9, 2,'tar', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (10, 2,'zip', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (11, 2,'rar', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (12, 2,'ace', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (13, 3,'txt', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (14, 3,'c', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (15, 3,'h', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (16, 3,'cpp', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (17, 3,'hpp', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (18, 3,'diz', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (19, 4,'xls', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (20, 4,'doc', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (21, 4,'dot', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (22, 4,'pdf', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (23, 4,'ai', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (24, 4,'ps', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (25, 4,'ppt', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (26, 5,'rm', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (27, 6,'wma', '');
INSERT INTO phpbb_extensions (ext_id, group_id, extension, comment) VALUES (28, 7,'swf', '');

# -- default quota limits
INSERT INTO phpbb_quota_limits (quota_limit_id, quota_desc, quota_limit) VALUES (1, 'Low', 262144);
INSERT INTO phpbb_quota_limits (quota_limit_id, quota_desc, quota_limit) VALUES (2, 'Medium', 2097152);
INSERT INTO phpbb_quota_limits (quota_limit_id, quota_desc, quota_limit) VALUES (3, 'High', 5242880);

# -- split topic type
ALTER TABLE phpbb_users ADD user_split_global_announce TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_split_announce TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_split_sticky TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_split_topic_split TINYINT(1) DEFAULT '0' NOT NULL;

# -- Post icon
ALTER TABLE phpbb_topics ADD topic_icon TINYINT(2);
ALTER TABLE phpbb_posts ADD post_icon TINYINT(2);
ALTER TABLE phpbb_posts ADD INDEX (post_icon);

# -- Announces Suite
ALTER TABLE phpbb_topics ADD topic_announce_duration MEDIUMINT(5) NOT NULL;
ALTER TABLE phpbb_auth_access ADD auth_global_announce TINYINT(1) NOT NULL AFTER auth_announce;
ALTER TABLE phpbb_forums ADD auth_global_announce TINYINT(2) NOT NULL AFTER auth_announce;
UPDATE phpbb_forums SET auth_global_announce=5;
ALTER TABLE phpbb_users ADD user_announcement_date_display TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_announcement_display TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_announcement_display_forum TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_announcement_split TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_announcement_forum TINYINT(1) DEFAULT '1' NOT NULL;

# -- Profile Control Panel
ALTER TABLE phpbb_users ADD user_realname VARCHAR(25) NOT NULL;
ALTER TABLE phpbb_users ADD user_gender TINYINT(1) UNSIGNED DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_users ADD user_birthday VARCHAR(8) DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_users ADD user_last_birthday INT(11) UNSIGNED DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_users ADD user_home_phone VARCHAR(20);
ALTER TABLE phpbb_users ADD user_home_fax VARCHAR(20);
ALTER TABLE phpbb_users ADD user_work_phone VARCHAR(20);
ALTER TABLE phpbb_users ADD user_work_fax VARCHAR(20);
ALTER TABLE phpbb_users ADD user_cellular VARCHAR(20);
ALTER TABLE phpbb_users ADD user_pager VARCHAR(20);
ALTER TABLE phpbb_users ADD user_summer_time TINYINT(1) UNSIGNED DEFAULT '0' NOT NULL;
ALTER TABLE phpbb_users ADD user_list_option VARCHAR(255);
ALTER TABLE phpbb_users ADD user_allow_email TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_allow_website TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_allow_messanger TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_allow_real TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_allow_sig TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_viewpm TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_viewwebsite TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_viewmessanger TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_viewreal TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_viewavatar TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_viewsig TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_viewimg TINYINT(1) DEFAULT '1' NOT NULL;
ALTER TABLE phpbb_users ADD user_buddy_friend_display TINYINT(1) DEFAULT '1';
ALTER TABLE phpbb_users ADD user_buddy_ignore_display TINYINT(1) DEFAULT '1';
ALTER TABLE phpbb_users ADD user_buddy_friend_of_display TINYINT(1) DEFAULT '1';
ALTER TABLE phpbb_users ADD user_buddy_ignored_by_display TINYINT(1) DEFAULT '1';
ALTER TABLE phpbb_users ADD user_watched_topics_per_page SMALLINT(3) DEFAULT '15';
ALTER TABLE phpbb_users ADD user_privmsgs_per_page SMALLINT(3) DEFAULT '5';
ALTER TABLE phpbb_sessions ADD session_robot VARCHAR(32);
ALTER TABLE phpbb_ranks CHANGE rank_title rank_title VARCHAR(255) NOT NULL;
ALTER TABLE phpbb_ranks ADD rank_max MEDIUMINT(8) NOT NULL AFTER rank_min; 

# -- Group ModeratorZ
ALTER TABLE phpbb_user_group ADD group_moderator TINYINT(1) NOT NULL;

# -- Cash Mod
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cash_disable',0);
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cash_display_after_posts',1);
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cash_post_message','You earned %s for that post');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cash_disable_spam_num',10);
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cash_disable_spam_time',24);
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cash_disable_spam_message','You have exceeded the alloted amount of posts and will not earn anything for your post');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cash_installed','yes');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cash_version','2.2.1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cash_adminbig','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cash_adminnavbar','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('points_name','Points');

# -- Board Statistics
INSERT INTO phpbb_stats_config (config_name, config_value) VALUES ('return_limit', '10');
INSERT INTO phpbb_stats_config (config_name, config_value) VALUES ('version', '2.1.5');
INSERT INTO phpbb_stats_config (config_name, config_value) VALUES ('modules_dir', 'stat_modules');
INSERT INTO phpbb_stats_config (config_name, config_value) VALUES ('page_views', '0');

# -- Last visit
ALTER TABLE phpbb_users ADD user_lastlogon INT (11) DEFAULT 0 not null;
UPDATE phpbb_users SET user_lastlogon=user_lastvisit WHERE user_lastlogon='0';
INSERT INTO phpbb_config (config_name, config_value) VALUES ('hidde_last_logon', '0');
ALTER TABLE phpbb_users ADD user_totaltime INT (11) DEFAULT '0';
ALTER TABLE phpbb_users ADD user_totallogon INT (11) DEFAULT '0';
ALTER TABLE phpbb_users ADD user_totalpages INT (11) DEFAULT '0';
UPDATE phpbb_users SET user_totaltime=(user_session_time-user_lastlogon) WHERE user_totaltime='0' AND user_lastlogon>0;
UPDATE phpbb_users SET user_totallogon=1 WHERE user_totallogon='0' AND user_session_time<>'0';

# -- Custom mass PM
ALTER TABLE phpbb_users ADD user_allow_mass_pm TINYINT (1) DEFAULT '2' AFTER user_allow_pm;
ALTER TABLE phpbb_groups ADD group_allow_pm TINYINT (2) DEFAULT '5' NOT NULL;

# -- Yellow card
ALTER TABLE phpbb_forums ADD auth_ban TINYINT (2) not null DEFAULT '3';
ALTER TABLE phpbb_forums ADD auth_greencard TINYINT (2) not null DEFAULT '5';
ALTER TABLE phpbb_forums ADD auth_bluecard TINYINT (2) not null DEFAULT '1';
ALTER TABLE phpbb_auth_access ADD auth_ban TINYINT (1) not null DEFAULT '0';
ALTER TABLE phpbb_auth_access ADD auth_greencard TINYINT (1) not null DEFAULT '0';
ALTER TABLE phpbb_auth_access ADD auth_bluecard TINYINT (1) not null DEFAULT '0';
INSERT INTO phpbb_config (config_name, config_value) VALUES ('bluecard_limit', '3');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('bluecard_limit_2', '1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_user_bancard', '10');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('report_forum', '0');
ALTER TABLE phpbb_users ADD user_warnings SMALLINT (5) DEFAULT '0';
ALTER TABLE phpbb_posts ADD post_bluecard TINYINT (1);

# -- add-on Country Flags for Profile Control Panel (PCP)
ALTER TABLE phpbb_users ADD user_flag varchar(25) NULL;
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','afghanistan','afghanistan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','albania','albania.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','algeria','algeria.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','andorra','andorra.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','angola','angola.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','antigua and barbuda','antiguabarbuda.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','argentina','argentina.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','armenia','armenia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','australia','australia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','austria','austria.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','azerbaijan','azerbaijan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','bahamas','bahamas.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','bahrain','bahrain.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','bangladesh','bangladesh.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','barbados','barbados.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','belarus','belarus.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','belgium','belgium.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','belize','belize.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','benin','benin.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','bhutan','bhutan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','bolivia','bolivia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','bosnia herzegovina','bosnia_herzegovina.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','botswana','botswana.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','brazil','brazil.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','brunei','brunei.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','bulgaria','bulgaria.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','burkinafaso','burkinafaso.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','burma','burma.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','burundi','burundi.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','cambodia','cambodia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','cameroon','cameroon.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','canada','canada.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','central african rep','centralafricanrep.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','chad','chad.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','chile','chile.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','china','china.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','columbia','columbia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','comoros','comoros.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','congo','congo.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','costarica','costarica.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','croatia','croatia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','cuba','cuba.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','cyprus','cyprus.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','czech republic','czechrepublic.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','demrepcongo','demrepcongo.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','denmark','denmark.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','djibouti','djibouti.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','dominica','dominica.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','dominican rep','dominicanrep.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','ecuador','ecuador.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','egypt','egypt.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','elsalvador','elsalvador.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','eq guinea','eq_guinea.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','eritrea','eritrea.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','estonia','estonia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','ethiopia','ethiopia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','fiji','fiji.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','finland','finland.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','france','france.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','gabon','gabon.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','gambia','gambia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','georgia','georgia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','germany','germany.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','ghana','ghana.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','greece','greece.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','grenada','grenada.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','grenadines','grenadines.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','guatemala','guatemala.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','guinea','guinea.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','guineabissau','guineabissau.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','guyana','guyana.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','haiti','haiti.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','honduras','honduras.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','hong kong','hong_kong.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','hungary','hungary.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','iceland','iceland.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','india','india.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','indonesia','indonesia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','iran','iran.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','iraq','iraq.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','ireland','ireland.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','israel','israel.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','italy','italy.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','ivory coast','ivorycoast.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','jamaica','jamaica.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','japan','japan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','jordan','jordan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','kazakhstan','kazakhstan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','kenya','kenya.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','kiribati','kiribati.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','kuwait','kuwait.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','kyrgyzstan','kyrgyzstan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','laos','laos.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','latvia','latvia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','lebanon','lebanon.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','liberia','liberia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','libya','libya.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','liechtenstein','liechtenstein.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','lithuania','lithuania.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','luxembourg','luxembourg.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','macadonia','macadonia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','macau','macau.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','madagascar','madagascar.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','malawi','malawi.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','malaysia','malaysia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','maldives','maldives.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','mali','mali.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','malta','malta.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','mauritania','mauritania.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','mauritius','mauritius.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','mexico','mexico.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','micronesia','micronesia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','moldova','moldova.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','monaco','monaco.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','mongolia','mongolia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','morocco','morocco.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','mozambique','mozambique.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','namibia','namibia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','nauru','nauru.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','nepal','nepal.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','neth antilles','neth_antilles.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','netherlands','netherlands.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','new zealand','newzealand.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','nicaragua','nicaragua.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','niger','niger.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','nigeria','nigeria.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','north korea','north_korea.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','norway','norway.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','oman','oman.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','pakistan','pakistan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','panama','panama.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','papua newguinea','papuanewguinea.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','paraguay','paraguay.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','peru','peru.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','philippines','philippines.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','poland','poland.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','portugal','portugal.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','puertorico','puertorico.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','qatar','qatar.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','quebec','quebec.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','rawanda','rawanda.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','romania','romania.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','russia','russia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','sao tome','sao_tome.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','saudiarabia','saudiarabia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','senegal','senegal.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','serbia','serbia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','seychelles','seychelles.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','sierraleone','sierraleone.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','singapore','singapore.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','slovakia','slovakia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','slovenia','slovenia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','solomon islands','solomon_islands.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','somalia','somalia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','south_korea','south_korea.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','south africa','southafrica.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','spain','spain.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','srilanka','srilanka.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','stkitts nevis','stkitts_nevis.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','stlucia','stlucia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','sudan','sudan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','suriname','suriname.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','sweden','sweden.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','switzerland','switzerland.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','syria','syria.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','taiwan','taiwan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','tajikistan','tajikistan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','tanzania','tanzania.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','thailand','thailand.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','togo','togo.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','tonga','tonga.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','trinidad and tobago','trinidadandtobago.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','tunisia','tunisia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','turkey','turkey.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','turkmenistan','turkmenistan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','tuvala','tuvala.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','uae','uae.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','uganda','uganda.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','uk','uk.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','ukraine','ukraine.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','uruguay','uruguay.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','usa','usa.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','ussr','ussr.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','uzbekistan','uzbekistan.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','vanuatu','vanuatu.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','venezuela','venezuela.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','vietnam','vietnam.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','western samoa','western_samoa.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','yemen','yemen.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','yugoslavia','yugoslavia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','zaire','zaire.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','zambia','zambia.gif');
INSERT INTO phpbb_flags (flag_id, flag_name, flag_image) VALUES ('','zimbabwe','zimbabwe.gif');
